#
# $Id$
#

package My::Error;

use strict;

use My::Config;

my $errFile = My::Config->get('errorFile');
my %errors;
if($errFile && open(IN, $errFile)) {
    while(<IN>) {
	chomp;
	next if /^\s*\#/;
	my($string, $code, $text) = split(/\s+/, $_, 3);
	$errors{$string} = { CODE => $code,
			     TEXT => $text };
    }
    close(IN);
}

sub getCode {
    my $self = shift;
    my $string = shift;

    $errors{$string}->{CODE};
}

sub getText {
    my $self = shift;
    my $string = shift;

    $errors{$string}->{TEXT};
}

1;
