#
# My::Config
#
# Copyright (c) 2001 by Michael Peppler. All rights reserved.
#
# $Id: //depot/http/lib/My/Template.pm#3 $
# $DateTime: 2001/06/25 11:26:36 $
# $Author: mpeppler $
#

package My::Config;

use strict;

use Carp;

sub import {
    my $self = shift;
    my $file = shift;

    if($file) {
	$ENV{CONFIG_FILE} = $file;
    }
}

my $DefaultConfig;


sub new {
    my $package = shift;
    my $file    = shift || $ENV{CONFIG_FILE};

    if($DefaultConfig && $DefaultConfig->{FILE} eq $file) {
	return $DefaultConfig;
    }

    my $self;
    $self = readfile($self, $file);

    $DefaultConfig = $self unless $DefaultConfig;

    bless($self, $package);
}

sub readfile {
    my $self = shift;
    my $file = shift;
    open(IN, $file) || croak("Can't open $file: $!");
    $self->{FILE} = $file;

    while(<IN>) {
	next if (/^\s*\#/);
	next if (/^\s*$/);

	chomp;

	my($key, $val) = split(/\s*=\s*/, $_);
	$key =~ s/^\s*//;

	$self->{DATA}->{lc($key)} = $val;
    }
    close(IN);
    $self;
}

sub get {
    my $self = shift;
    my $key  = shift;

    if(!ref($self)) {
#	$key = $self;
	if(!$DefaultConfig) {
	    $self->new; # $self;
	}
	$self = $DefaultConfig;
    }

    $self->{DATA}->{lc($key)};
}

sub reload {
    my $self = shift;

    $self->readfile($self->{FILE});
}

1;
